<?php


/*******************   vBml parser  *******************
*
* Marking up forum posts with square bracket[] tags
* has become very common
*
* vBml parser is a php based script that will parse the
* square bracked mark up and convert it to valid HTML.
*
* For now the parser can convert:
*
* Styles:
* bold:        [b]text[/b]
* italic:      [i]text[/i]
* underline:   [u]text[/u]
*
* Text color:  [color=red]text[/color]
* Font family: [font=times]text[/font]
* Font size:   [size=200]text[/size]   = 200 percent
*
* Link a:      [url]domain[/url]
* Link b:      [url=domain]display text[/url]
* Links open in a new page
*
* Email a:     [email]email address[/email]
* Email b:     [email=email address]display text[/email]
*
* Image:       [img]image url[/img]
*
* Quote:       [quote]text[/quote]
*
* All the tags can be nested to create complex styles
*
* Enjoy!
*
* Author: Denny Schlesinger
* Copyright &copy; 2004-2005 by Denny Schlesinger
*
*******************************************************/


function vBml ($text) {

    // [bold]
    $text = str_replace ("[b]" ,"<b>" ,$text); 
    $text = str_replace ("[B]" ,"<b>" ,$text); 
    $text = str_replace ("[/b]" ,"</b>" ,$text); 
    $text = str_replace ("[/B]" ,"</b>" ,$text); 
    
    // [italic]
    $text = str_replace ("[i]" ,"<i>" ,$text); 
    $text = str_replace ("[I]" ,"<i>" ,$text); 
    $text = str_replace ("[/i]" ,"</i>" ,$text); 
    $text = str_replace ("[/I]" ,"</i>" ,$text); 
    
    // [underline]
    $text = str_replace ("[u]" ,"<u>" ,$text); 
    $text = str_replace ("[U]" ,"<u>" ,$text); 
    $text = str_replace ("[/u]" ,"</u>" ,$text); 
    $text = str_replace ("[/U]" ,"</u>" ,$text); 
    
    // [color]
    $text = str_replace("[COLOR=", "[color=", $text);
    $text = str_replace("[/COLOR]", "[/color]", $text);
    $limit = 0;
    while (($pos = strpos ( $text, "[color=", $limit)) !== FALSE) {
    
        if (($pos1 = strpos ( $text, "]", $pos)) !== FALSE) {
        if (($pos2 = strpos ( $text, "[/color]", $pos1)) !== FALSE) {
        if ($pos1 - $pos < 15) {
            $text = substr_replace ($text, "</span>", $pos2, 8);
            $text = substr_replace ($text, "\">", $pos1, 1);
            $text = substr_replace ($text, "<span style=\"color:", $pos, 7);
        }}}
        $limit = $pos +1;
    }
    
    // [font-size]
    $text = str_replace("[SIZE=", "[size=", $text);
    $text = str_replace("[/SIZE]", "[/size]", $text);
    $limit = 0;
    while (($pos = strpos ( $text, "[size=", $limit)) !== FALSE) {
    
        if (($pos1 = strpos ( $text, "]", $pos)) !== FALSE) {
        if (($pos2 = strpos ( $text, "[/size]", $pos1)) !== FALSE) {
        if ($pos1 - $pos < 15) {
            $text = substr_replace ($text, "</span>", $pos2, 7);
            $text = substr_replace ($text, "%\">", $pos1, 1);
            $text = substr_replace ($text, "<span style=\"font-size:", $pos, 6);
        }}}
        $limit = $pos +1;
    }
    
    // [font-family]
    $text = str_replace("[FONT=", "[font=", $text);
    $text = str_replace("[/FONT]", "[/font]", $text);
    $limit = 0;
    while (($pos = strpos ( $text, "[font=", $limit)) !== FALSE) {
    
        if (($pos1 = strpos ( $text, "]", $pos)) !== FALSE) {
        if (($pos2 = strpos ( $text, "[/font]", $pos1)) !== FALSE) {
        if ($pos1 - $pos < 20) {
            $text = substr_replace ($text, "</span>", $pos2, 7);
            $text = substr_replace ($text, "\">", $pos1, 1);
            $text = substr_replace ($text, "<span style=\"font-family:", $pos, 6);
        }}}
        $limit = $pos +1;
    }
    
    // [url]
    $text = str_replace("[URL]", "[url]", $text);
    $text = str_replace("[URL=", "[url=", $text);
    $text = str_replace("[/URL]", "[/url]", $text);
    
    $limit = 0;
    $starttag = "<a href=\"";
    while (($pos = strpos ( $text, "[url]", $limit)) !== FALSE) {

        if (($pos1 = strpos ( $text, "]", $pos)) !== FALSE) {
        if (($pos2 = strpos ( $text, "[/url]", $pos1)) !== FALSE) {
        if ($pos1 - $pos < 255) {
            $url = substr ($text, $pos1 + 1, $pos2 - $pos1 - 1);
            if (strpos ( $url, "http://", 0) === FALSE) {
                $starttag .= "http://";
            }
            $text = substr_replace ($text, "\" target=\"_blank\">" . $url . "</a>", $pos2, 6);
            $text = substr_replace ($text, $starttag, $pos, 5);
        }}}
        $limit = $pos +1;
    }

    $limit = 0;
    $starttag = "<a href=\"";
    while (($pos = strpos ( $text, "[url=", $limit)) !== FALSE) {

        if (($pos1 = strpos ( $text, "]", $pos)) !== FALSE) {
        if (($pos2 = strpos ( $text, "[/url]", $pos1)) !== FALSE) {
        if ($pos1 - $pos < 255) {
            $url = substr ($text, $pos + 5, $pos1 - $pos - 5);
            if (strpos ( $url, "http://", 0) === FALSE) {
                $starttag .= "http://";
            }
            $text = substr_replace ($text, "</a>", $pos2, 6);
            $text = substr_replace ($text, "\" target=\"_blank\">", $pos1, 1);
            $text = substr_replace ($text, $starttag, $pos, 5);
        }}}
        $limit = $pos +1;
    }

    // [email]
    $text = str_replace("[EMAIL]", "[email]", $text);
    $text = str_replace("[EMAIL=", "[email=", $text);
    $text = str_replace("[/EMAIL]", "[/email]", $text);
    
    $limit = 0;
    $starttag = "<a href=\"mailto:";
    while (($pos = strpos ( $text, "[email]", $limit)) !== FALSE) {

        if (($pos1 = strpos ( $text, "]", $pos)) !== FALSE) {
        if (($pos2 = strpos ( $text, "[/email]", $pos1)) !== FALSE) {
        if ($pos1 - $pos < 255) {
            $email = substr ($text, $pos1 + 1, $pos2 - $pos1 - 1);
            $text = substr_replace ($text, "\">" . $email . "</a>", $pos2, 8);
            $text = substr_replace ($text, $starttag, $pos, 7);
        }}}
        $limit = $pos +1;
    }

    $limit = 0;
    $starttag = "<a href=\"mailto:";
    while (($pos = strpos ( $text, "[email=", $limit)) !== FALSE) {

        if (($pos1 = strpos ( $text, "]", $pos)) !== FALSE) {
        if (($pos2 = strpos ( $text, "[/email]", $pos1)) !== FALSE) {
        if ($pos1 - $pos < 255) {
            $email = substr ($text, $pos + 5, $pos1 - $pos - 5);
            $text = substr_replace ($text, "</a>", $pos2, 8);
            $text = substr_replace ($text, "\">", $pos1, 1);
            $text = substr_replace ($text, $starttag, $pos, 7);
        }}}
        $limit = $pos +1;
    }

    // [img]
    $text = str_replace("[IMG]", "[img]", $text);
    $text = str_replace("[/IMG]", "[/img]", $text);
    
    $limit = 0;
    $starttag = "<img src=\"";
    while (($pos = strpos ( $text, "[img]", $limit)) !== FALSE) {

        if (($pos1 = strpos ( $text, "]", $pos)) !== FALSE) {
        if (($pos2 = strpos ( $text, "[/img]", $pos1)) !== FALSE) {
        if ($pos1 - $pos < 255) {
            $text = substr_replace ($text, "\" border=\"0\" alt=\"\">", $pos2, 8);
            $text = substr_replace ($text, $starttag, $pos, 5);
        }}}
        $limit = $pos +1;
    }

    // [quote]
    $text = str_replace("[QUOTE]", "[quote]", $text);
    $text = str_replace("[/QUOTE]", "[/quote]", $text);
    
    $limit = 0;
    $starttag = "<blockquote><span style=\"font-family:verdana,arial,helvetica; font-size:75%\">quote:</span><hr>";
    while (($pos = strpos ( $text, "[quote]", $limit)) !== FALSE) {

        if (($pos1 = strpos ( $text, "]", $pos)) !== FALSE) {
        if (($pos2 = strpos ( $text, "[/quote]", $pos1)) !== FALSE) {
        if ($pos1 - $pos < 255) {
            $text = substr_replace ($text, "<hr></blockquote>", $pos2, 8);
            $text = substr_replace ($text, $starttag, $pos, 7);
        }}}
        $limit = $pos +1;
    }

    // [table]
    $text = str_replace("[TABLE]", "[table]", $text);
    $text = str_replace("[/TABLE]", "[/table]", $text);
    
    $limit = 0;
    $starttag = "<blockquote><span style=\"font-family:verdana,arial,helvetica; font-size:75%\">table:</span><hr>\n<pre>";
    while (($pos = strpos ( $text, "[table]", $limit)) !== FALSE) {

        if (($pos1 = strpos ( $text, "]", $pos)) !== FALSE) {
        if (($pos2 = strpos ( $text, "[/table]", $pos1)) !== FALSE) {
        if ($pos1 - $pos < 255) {
            $text = substr_replace ($text, "</pre><hr></blockquote>", $pos2, 8);
            $text = substr_replace ($text, $starttag, $pos, 7);
        }}}
        $limit = $pos +1;
    }

    return $text;

} // function vBml ($text)



/***************************** The End *****************************/

if (!isset($_POST['text'])) { 
    $input  = "Put your [color=blue]text[/color] here\n";
    $input .= "Put your [size=200]text[/size] here\n";
    $input .= "Put your [font=webdings]text[/font] here\n";
    $input .= "Put your [b][i][u]text[/u][/i][/b] here"; 
} else { 
    $input = $_POST['text']; 
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>vBml parser</title>
</head>
<body>
<a name="top"></a>
<table width="400" border="0">
  <tr>
    <td>
      <span style="font-family:Courier New"><pre>
/*******************   vBml parser  *******************
* <a href="vbml-parser.php.tgz">Download the code</a>
* <a href="../tools.php">More Cardumen Tools</a>
* <a href="#docs">Documentation</a>
*
* Enjoy!
* Author: Denny Schlesinger
* Copyright &copy; 2004-2005 by Denny Schlesinger
*******************************************************/
</pre></span>  
    </td>
  </tr>
  <tr>
    <td>
<?php if (isset($_POST['text'])) { ?>
      <b>Preview:</b><hr>
      <?php echo nl2br (vBml ($_POST['text'])); ?>
      <hr><br>
      <b>HTML output created by vBml parser:</b><br><br>
      
      <?php echo nl2br (htmlentities (vBml ($_POST['text']))); ?>
      <hr>
<?php }  ?>
      <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
        <b>Input:</b><br>
        <textarea name="text" rows="7" cols="60"><?php echo $input; ?></textarea>
        <br><br>
        <input type="submit" name="" value="Preview">&nbsp;&nbsp;&nbsp;
        <input type="reset" name="" value="Reset">
      </form>
    </td>
  </tr>
  <tr>
    <td>
      <span style="font-family:Courier New"><pre>
 <a name="docs"></a>

/*******************   vBml parser  *******************
*
* Marking up forum posts with square bracket[] tags
* has become very common
*
* vBml parser is a php based script that will parse the
* square bracked mark up and convert it to valid HTML.
*
* For now the parser can convert:
*
* Styles:
* bold:        [b]text[/b]
* italic:      [i]text[/i]
* underline:   [u]text[/u]
*
* Text color:  [color=red]text[/color]
* Font family: [font=times]text[/font]
* Font size:   [size=200]text[/size]   = 200 percent
*
* Link a:      [url]domain[/url]
* Link b:      [url=domain]display text[/url]
* Links open in a new page
*
* Email a:     [email]email address[/email]
* Email b:     [email=email address]display text[/email]
*
* Image:       [img]image url[/img]
*
* Quote:       [quote]text[/quote]
*
* All the tags can be nested to create complex styles
*
* Enjoy!
*
* Author: Denny Schlesinger
* Copyright &copy; 2004-2005 by Denny Schlesinger          <a href="#top">Top</a>
*
*******************************************************/
</pre></span>  
    </td>
  </tr>
</table>
</body>
</html>
