<?php

// Horizontal and Vertical Gantt Charts
// with php, HTML and CSSS
// Copyright (C) 2010, Denny Schlesinger
// You may use this code and code derived from this code
// freely but please include in full this Copyright notice


// The values array simulates a data source
// most likely a database
$values = array();
$values['sunday'] = 345;
$values['monday'] = 231;
$values['tuesday'] = 115;
$values['wednesday'] = 209;
$values['thursday'] = 333;
$values['friday'] = 456;
$values['saturday'] = 311;


// The $html variable contains the whole
// HTML and CSS code as a heredoc construct

// The width or height of the bars is achieved by 
// modifying the css width and height attributes
// look for these substitutions 
// width:{$values['sunday']}px;
// which is how the data is passed to the CSS code

// You can easily change the colors of the bars by
// a similar method.

$html = <<<HTMLHTML
<!DOCTYPE html>
<html lang="en">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<title>Gantt Bar Chart Tutorial by captainccs</title>
<style type="text/css">
div.bar {
    height:20px;
    background-color:blue;
}
div.rod {
    width:20px;
    margin:auto;
    background-color:blue;
}
td.bottom {
    vertical-align:bottom;
}
td.center {
    text-align:center;
    width:14%;
}
div.sunday {
    width:{$values['sunday']}px;
}
div.monday {
    width:{$values['monday']}px;
}
div.tuesday {
    width:{$values['tuesday']}px;
}
div.wednesday {
    width:{$values['wednesday']}px;
}
div.thursday {
    width:{$values['thursday']}px;
}
div.friday {
    width:{$values['friday']}px;
}
div.saturday {
    width:{$values['saturday']}px;
}
div.sundayv {
    height:{$values['sunday']}px;
}
div.mondayv {
    height:{$values['monday']}px;
}
div.tuesdayv {
    height:{$values['tuesday']}px;
}
div.wednesdayv {
    height:{$values['wednesday']}px;
}
div.thursdayv {
    height:{$values['thursday']}px;
}
div.fridayv {
    height:{$values['friday']}px;
}
div.saturdayv {
    height:{$values['saturday']}px;
}
table {
    border:2px solid gray;
    width:600px;
}
</style>
</head>
<body>
<h2>Gantt Bar Chart Tutorial by captainccs</h2>
<p>To see how it's done, please <a href="gantt.php.tgz">download</a> the .tgz file<br>
<a href="../tools.php">More cardumen tools</a></p>
<table>
<tr>
<td style="width:100px;">Sunday</td>
<td><div class="sunday bar"></div></td>
</tr>
<tr>
<td>Monday</td>
<td><div class="monday bar"></div></td>
</tr>
<tr>
<td>Tuesday</td>
<td><div class="tuesday bar"></div></td>
</tr>
<tr>
<td>Wednesday</td>
<td><div class="wednesday bar"></div></td>
</tr>
<tr>
<td>Thursday</td>
<td><div class="thursday bar"></div></td>
</tr>
<tr>
<td>Friday</td>
<td><div class="friday bar"></div></td>
</tr>
<tr>
<td>Saturday</td>
<td><div class="saturday bar"></div></td>
</tr>
</table>
<br><br>
<table>
<tr>
<td class="bottom"><div class="sundayv rod"></div></td>
<td class="bottom"><div class="mondayv rod"></div></td>
<td class="bottom"><div class="tuesdayv rod"></div></td>
<td class="bottom"><div class="wednesdayv rod"></div></td>
<td class="bottom"><div class="thursdayv rod"></div></td>
<td class="bottom"><div class="fridayv rod"></div></td>
<td class="bottom"><div class="saturdayv rod"></div></td>
</tr>
<tr>
<td class="center">Sunday</td>
<td class="center">Monday</td>
<td class="center">Tuesday</td>
<td class="center">Wednesday</td>
<td class="center">Thursday</td>
<td class="center">Friday</td>
<td class="center">Saturday</td>
</tr>
</table>
</body>
</html>
HTMLHTML;

echo $html;

?>